<?php

use AFEB\Form;
use AFEB\Helper;
use AFEB\Strs;

if (!defined('ABSPATH')) exit;

?>
<table class="form-table">
    <tbody>
        <?php
        global $post;
        $post_id = isset($post->ID) ? absint($post->ID) : -1;
        $form_fields = get_post_meta($post_id, 'afeb_form_fields', true);

        if (is_array($form_fields) && count($form_fields) > 0) {
            $unknown_label = esc_html__('Unknown', 'addons-for-elementor-builder');

            foreach ($form_fields as $field_key => $field_data) {
                $sanitized_form_field_key = sanitize_key($field_key);
        ?>
                <tr>
                    <th scope="row">
                        <label for="<?php echo esc_attr($sanitized_form_field_key); ?>">
                            <?php echo !empty($field_data['label']) ? esc_html($field_data['label']) : $unknown_label; ?>
                        </label>
                    </th>
                    <td>
                        <?php
                        $value = !empty($field_data['value']) ? $field_data['value'] : '';
                        $type = !empty($field_data['type']) ? sanitize_key($field_data['type']) : '';
                        $new_options = $explode_options = [];
                        $options = !empty($field_data['options']) ? preg_split("/\\r\\n|\\r|\\n/", $field_data['options']) : [];

                        foreach ($options as $key => $option) {
                            $explode_options = explode(' ', $option);
                        }

                        foreach ($explode_options as $key => $option) {
                            if (strpos($option, '|') !== false) {
                                list($label, $key) = explode('|', $option);
                                $new_options[sanitize_key($key)] = esc_html($label);
                            }
                        }

                        switch ($type) {
                            case 'text':
                            case 'email':
                            case 'url':
                            case 'number':
                            case 'tel':
                            case 'date':
                            case 'time':
                            case 'password':
                            case 'hidden':
                            case 'textarea':
                                echo Form::input([
                                    'class' => 'widefat',
                                    'type' => $type,
                                    'name'  => "afeb-form-fields[{$sanitized_form_field_key}]",
                                    'value' => $value
                                ], $value);
                                break;

                            case 'radio':
                            case 'checkbox':
                                $radio_hidden = false;
                                foreach ($new_options as $option_value => $label) {
                                    $args = [
                                        'class' => 'widefat',
                                        'type' => $type,
                                        'name'  => "afeb-form-fields[{$sanitized_form_field_key}]",
                                        'value' => $option_value
                                    ];

                                    echo '<label>';

                                    if ($type == 'checkbox') {

                                        if (count($new_options) > 1) {
                                            $args['name'] = $args['name'] . '[]';
                                        }

                                        $new_args = $args;
                                        $new_args['type'] = 'hidden';
                                        $new_args['value'] = '';

                                        echo Form::input($new_args);

                                        if ((is_array($value) && in_array($option_value, $value)) || $option_value == $value) {
                                            $args['checked'] = 'checked';
                                        }
                                    }

                                    if ($type == 'radio') {

                                        if ($radio_hidden === false) {
                                            $new_args = $args;
                                            $new_args['type'] = 'hidden';
                                            $new_args['value'] = '';

                                            echo Form::input($new_args);
                                            $radio_hidden = true;
                                        }

                                        if ($option_value === $value) {
                                            $args['checked'] = 'checked';
                                        }
                                    }

                                    echo Form::input($args) . ' ' . esc_html($label) . '<br><br></label>';
                                }
                                break;

                            case 'select':
                                echo Form::select([
                                    'class' => 'widefat',
                                    'name'  => "afeb-form-fields[{$sanitized_form_field_key}]"
                                ], ['values' => $new_options, 'selected' => $value]);
                                break;

                            case 'upload':
                                // Handle the value as an array of file URLs
                                $file_urls = is_array($value) ? $value : explode('|', trim($value, '|'));

                                foreach ($file_urls as $file_url) {
                                    // Sanitize and validate the file URL
                                    $file_url = esc_url_raw(trim($file_url));
                                    if (!filter_var($file_url, FILTER_VALIDATE_URL)) {
                                        continue;
                                    }

                                    // Ensure the file is within the WordPress uploads directory
                                    $wp_upload_dir = wp_upload_dir();
                                    if (strpos($file_url, $wp_upload_dir['baseurl']) !== 0) {
                                        continue;
                                    }

                                    // Extract file extension
                                    $file_path = parse_url($file_url, PHP_URL_PATH);

                                    // Secure output: display file link
                                    $file_name = basename($file_path);
                                    echo '<a href="' . esc_url($file_url) . '" target="_blank" title="' . esc_attr($file_name) . '" style="text-decoration:none">' . esc_html($file_name) . '</a><br><br>';
                                }
                                break;

                            default:
                                echo esc_html__('Unsupported field type or no value provided.', 'addons-for-elementor-builder');
                                break;
                        }
                        ?>
                    </td>
                </tr>
        <?php
            }

            wp_nonce_field('afeb_submissions_cpt', '_afeb_submissions_nonce');
        } else {
            echo '<tr><td>' . wp_kses(Helper::front_notice(Strs::msgs('no_itm'), 'error'), Helper::allowed_tags(['div'])) . '<td></tr>';
        }
        ?>
    </tbody>
</table>