<?php

namespace AFEB;

if (!defined('ABSPATH')) {
    exit;
}

/**
 * "Vertex Addons for Elementor" Strs Class
 * 
 * @class Strs
 * @version 1.0.2
 */
class Strs
{
    /**
     * Get a message
     * 
     * @param string $key
     *
     * @return string
     *@since 1.0.7
     *
     */
    public static function msgs(string $key = ''): string
    {
        $output = apply_filters('afeb/strs/msgs', [
            /* translators: %s is replaced with "PRO" */
            'use_pro' => __('To use this feature, Please upgrade the plugin to the %s version', 'addons-for-elementor-builder'),
            'no_itm' => __('Unfortunately, there is no item to display', 'addons-for-elementor-builder'),
            'use_dsply_cndtn' => __('For more advanced settings, use the «Conditional Display» option in the Advanced tab', 'addons-for-elementor-builder'),
            'tmplt_desc' => __('Using this control, you can select a pre-built Elementor template to display in the off-canvas menu, or you can create your custom template using the Elementor template builder first and then select that template for this section', 'addons-for-elementor-builder'),
            'btn_err' => __('You cannot add a repeated button. Please modify it to another button or delete it', 'addons-for-elementor-builder'),
            'new_rw' => __('You must start a new row, Please change the action to "Start New Row"', 'addons-for-elementor-builder'),
            'new_cel' => __('You must add a new cell, Please change the action to "Add New Cell"', 'addons-for-elementor-builder'),
            'dsbl_api_ky' => __('The API key is disabled in the editor. To view changes with the API key, use the preview mode', 'addons-for-elementor-builder'),
            'slct_mnu' => __('Please select a Menu From Setting!', 'addons-for-elementor-builder')
        ]);

        return isset($output[$key]) ? esc_html($output[$key]) : '';
    }

    /**
     * Get a label
     * 
     * @param string $key
     *
     * @return string
     *@since 1.2.0
     *
     */
    public static function lbls(string $key = ''): string
    {
        $output = apply_filters('afeb/strs/lbls', [
            'clr' => __('Color', 'addons-for-elementor-builder'),
            'tmplt' => __('Template', 'addons-for-elementor-builder')
        ]);

        return isset($output[$key]) ? esc_html($output[$key]) : '';
    }

    /**
     * @param int $index
     * @param bool $lower
     *
     * @return string
     *@since 1.1.0
     *
     */
    public static function key_words(int $index, bool $lower = true): string
    {
        $output = apply_filters('afeb/strs/key_words', [
            'Addons',
            'Builder',
            'Control',
            'Divider',
            'Embed',
            'Form',
            'Global',
            'Hotspot',
            'InformationBox',
            'Jumper',
            'Kits',
            'Login,Register',
            'Map',
            'NewsTicker',
            'Order',
            'PriceBox',
            'Query',
            'ReadingProgressBar',
            'Search',
            'Timeline',
            'Upper',
            'VideoPlayer',
            'WooCommerce',
            'Xterm',
            'YoutubeFeed',
            'Zero'
        ]);

        return isset($output[$index]) ? ($lower ? strtolower($output[$index]) : $output[$index]) : '';
    }

    /**
     * Get the font icons strings
     * 
     * @since 1.0.7
     * 
     * @return array
     */
    public static function get_font_icons(): array
    {
        $font_icons =  [
            '',
            'fas fa-glass-martini',
            'fa fa-music',
            'fa fa-search',
            'far fa-envelope',
            'fa fa-heart',
            'fa fa-star',
            'far fa-star',
            'fa fa-user',
            'fa fa-film',
            'fa fa-th-large',
            'fa fa-th',
            'fa fa-th-list',
            'fa fa-check',
            'fa fa-times',
            'fa fa-search-plus',
            'fa fa-search-minus',
            'fa fa-power-off',
            'fa fa-signal',
            'fa fa-cog',
            'far fa-trash-alt',
            'fa fa-home',
            'far fa-file',
            'far fa-clock',
            'fa fa-road',
            'fa fa-download',
            'far fa-arrow-alt-circle-down',
            'far fa-arrow-alt-circle-up',
            'fa fa-inbox',
            'far fa-play-circle',
            'fas fa-redo-alt',
            'fas fa-sync-alt',
            'fa fa-list-alt',
            'fa fa-lock',
            'fa fa-flag',
            'fa fa-headphones',
            'fa fa-volume-off',
            'fa fa-volume-down',
            'fa fa-volume-up',
            'fa fa-qrcode',
            'fa fa-barcode',
            'fa fa-tag',
            'fa fa-tags',
            'fa fa-book',
            'fa fa-bookmark',
            'fa fa-print',
            'fa fa-camera',
            'fa fa-font',
            'fa fa-bold',
            'fa fa-italic',
            'fa fa-text-height',
            'fa fa-text-width',
            'fa fa-align-left',
            'fa fa-align-center',
            'fa fa-align-right',
            'fa fa-align-justify',
            'fa fa-list',
            'fa fa-outdent',
            'fa fa-indent',
            'fas fa-video',
            'far fa-image',
            'fas fa-pencil-alt',
            'fa fa-map-marker',
            'fa fa-adjust',
            'fa fa-tint',
            'fas fa-edit',
            'fas fa-share-square',
            'far fa-check-square',
            'fas fa-arrows-alt',
            'fa fa-step-backward',
            'fa fa-fast-backward',
            'fa fa-backward',
            'fa fa-play',
            'fa fa-pause',
            'fa fa-stop',
            'fa fa-forward',
            'fa fa-fast-forward',
            'fa fa-step-forward',
            'fa fa-eject',
            'fa fa-chevron-left',
            'fa fa-chevron-right',
            'fa fa-plus-circle',
            'fa fa-minus-circle',
            'fa fa-times-circle',
            'fa fa-check-circle',
            'fa fa-question-circle',
            'fa fa-info-circle',
            'fa fa-crosshairs',
            'far fa-times-circle',
            'far fa-check-circle',
            'fa fa-ban',
            'fa fa-arrow-left',
            'fa fa-arrow-right',
            'fa fa-arrow-up',
            'fa fa-arrow-down',
            'fa fa-share',
            'fa fa-expand',
            'fa fa-compress',
            'fa fa-plus',
            'fa fa-minus',
            'fa fa-asterisk',
            'fa fa-exclamation-circle',
            'fa fa-gift',
            'fa fa-leaf',
            'fa fa-fire',
            'fa fa-eye',
            'fa fa-eye-slash',
            'fa fa-exclamation-triangle',
            'fa fa-plane',
            'fa fa-calendar',
            'fa fa-random',
            'fa fa-comment',
            'fa fa-magnet',
            'fa fa-chevron-up',
            'fa fa-chevron-down',
            'fa fa-retweet',
            'fa fa-shopping-cart',
            'fa fa-folder',
            'fa fa-folder-open',
            'fas fa-arrows-alt-v',
            'fas fa-arrows-alt-h',
            'far fa-chart-bar',
            'fab fa-twitter-square',
            'fab fa-facebook-square',
            'fa fa-camera-retro',
            'fa fa-key',
            'fa fa-cogs',
            'fa fa-comments',
            'far fa-thumbs-up',
            'far fa-thumbs-down',
            'fa fa-star-half',
            'far fa-heart',
            'fas fa-sign-out-alt',
            'fab fa-linkedin',
            'fas fa-thumbtack',
            'fas fa-external-link-alt',
            'fas fa-sign-in-alt',
            'fa fa-trophy',
            'fab fa-github-square',
            'fa fa-upload',
            'far fa-lemon',
            'fas fa-phone-alt',
            'far fa-square',
            'far fa-bookmark',
            'fas fa-phone-square-alt',
            'fab fa-twitter',
            'fab fa-facebook',
            'fab fa-github',
            'fa fa-unlock',
            'fa fa-credit-card',
            'fa fa-rss',
            'far fa-hdd',
            'fa fa-bullhorn',
            'fa fa-bell',
            'fa fa-certificate',
            'far fa-hand-point-right',
            'far fa-hand-point-left',
            'far fa-hand-point-up',
            'far fa-hand-point-down',
            'fa fa-arrow-circle-left',
            'fa fa-arrow-circle-right',
            'fa fa-arrow-circle-up',
            'fa fa-arrow-circle-down',
            'fa fa-globe',
            'fa fa-wrench',
            'fa fa-tasks',
            'fa fa-filter',
            'fa fa-briefcase',
            'fa fa-arrows-alt',
            'fa fa-users',
            'fa fa-link',
            'fa fa-cloud',
            'fa fa-flask',
            'fas fa-cut',
            'far fa-copy',
            'fa fa-paperclip',
            'far fa-save',
            'fa fa-square',
            'fa fa-bars',
            'fa fa-list-ul',
            'fa fa-list-ol',
            'fa fa-strikethrough',
            'fa fa-underline',
            'fa fa-table',
            'fa fa-magic',
            'fa fa-truck',
            'fab fa-pinterest',
            'fab fa-pinterest-square',
            'fab fa-google-plus-square',
            'fab fa-google-plus-g',
            'far fa-money-bill-alt',
            'fa fa-caret-down',
            'fa fa-caret-up',
            'fa fa-caret-left',
            'fa fa-caret-right',
            'fa fa-columns',
            'fa fa-sort',
            'fas fa-sort-down',
            'fas fa-sort-up',
            'fa fa-envelope',
            'fab fa-linkedin-in',
            'fa fa-undo',
            'fa fa-gavel',
            'fas fa-tachometer-alt',
            'far fa-comment',
            'far fa-comments',
            'fa fa-bolt',
            'fa fa-sitemap',
            'fa fa-umbrella',
            'fa fa-clipboard',
            'far fa-lightbulb',
            'fas fa-exchange-alt',
            'fas fa-cloud-download-alt',
            'fas fa-cloud-upload-alt',
            'fa fa-user-md',
            'fa fa-stethoscope',
            'fa fa-suitcase',
            'far fa-bell',
            'fa fa-coffee',
            'fas fa-utensils',
            'far fa-file-alt',
            'far fa-building',
            'far fa-hospital',
            'fa fa-ambulance',
            'fa fa-medkit',
            'fa fa-fighter-jet',
            'fa fa-beer',
            'fa fa-h-square',
            'fa fa-plus-square',
            'fa fa-angle-double-left',
            'fa fa-angle-double-right',
            'fa fa-angle-double-up',
            'fa fa-angle-double-down',
            'fa fa-angle-left',
            'fa fa-angle-right',
            'fa fa-angle-up',
            'fa fa-angle-down',
            'fa fa-desktop',
            'fa fa-laptop',
            'fa fa-tablet',
            'fa fa-mobile',
            'far fa-circle',
            'fa fa-quote-left',
            'fa fa-quote-right',
            'fa fa-spinner',
            'fa fa-circle',
            'fa fa-reply',
            'fab fa-github-alt',
            'far fa-folder',
            'far fa-folder-open',
            'far fa-smile',
            'far fa-frown',
            'far fa-meh',
            'fa fa-gamepad',
            'far fa-keyboard',
            'far fa-flag',
            'fa fa-flag-checkered',
            'fa fa-terminal',
            'fa fa-code',
            'fa fa-reply-all',
            'fas fa-star-half-alt',
            'fa fa-location-arrow',
            'fa fa-crop',
            'fas fa-unlink',
            'fa fa-question',
            'fa fa-info',
            'fa fa-exclamation',
            'fa fa-superscript',
            'fa fa-subscript',
            'fa fa-eraser',
            'fa fa-puzzle-piece',
            'fa fa-microphone',
            'fa fa-microphone-slash',
            'fas fa-shield-alt',
            'far fa-calendar',
            'fa fa-fire-extinguisher',
            'fa fa-rocket',
            'fab fa-maxcdn',
            'fa fa-chevron-circle-left',
            'fa fa-chevron-circle-right',
            'fa fa-chevron-circle-up',
            'fa fa-chevron-circle-down',
            'fab fa-html5',
            'fab fa-css3',
            'fa fa-anchor',
            'fa fa-unlock-alt',
            'fa fa-bullseye',
            'fa fa-ellipsis-h',
            'fa fa-ellipsis-v',
            'fa fa-rss-square',
            'fa fa-play-circle',
            'fas fa-ticket-alt',
            'fa fa-minus-square',
            'far fa-minus-square',
            'fas fa-level-up-alt',
            'fas fa-level-down-alt',
            'fa fa-check-square',
            'fas fa-pen-square',
            'fas fa-external-link-square-alt',
            'fa fa-share-square',
            'fa fa-compass',
            'fas fa-caret-square-down',
            'fas fa-caret-square-up',
            'fas fa-caret-square-right',
            'fas fa-euro-sign',
            'fas fa-pound-sign',
            'fas fa-dollar-sign',
            'fas fa-rupee-sign',
            'fas fa-yen-sign',
            'fas fa-ruble-sign',
            'fas fa-won-sign',
            'fab fa-btc',
            'fa fa-file',
            'fas fa-file-alt',
            'fas fa-sort-alpha-down',
            'fas fa-sort-alpha-down-alt',
            'fas fa-sort-amount-down-alt',
            'fas fa-sort-amount-down',
            'fas fa-sort-numeric-down',
            'fas fa-sort-numeric-down-alt',
            'fa fa-thumbs-up',
            'fa fa-thumbs-down',
            'fab fa-youtube-square',
            'fab fa-youtube',
            'fab fa-xing',
            'fab fa-xing-square',
            'fab fa-apple-pay',
            'fab fa-dropbox',
            'fab fa-stack-overflow',
            'fab fa-instagram',
            'fab fa-flickr',
            'fab fa-adn',
            'fab fa-bitbucket',
            'fas fa-place-of-worship',
            'fab fa-tumblr',
            'fab fa-tumblr-square',
            'fas fa-long-arrow-alt-down',
            'fas fa-long-arrow-alt-up',
            'fas fa-long-arrow-alt-left',
            'fas fa-long-arrow-alt-right',
            'fab fa-windows',
            'fab fa-android',
            'fab fa-linux',
            'fab fa-dribbble',
            'fab fa-skype',
            'fab fa-foursquare',
            'fab fa-trello',
            'fa fa-female',
            'fa fa-male',
            'fab fa-gratipay',
            'far fa-sun',
            'far fa-moon',
            'fa fa-archive',
            'fa fa-bug',
            'fab fa-vk',
            'fab fa-weibo',
            'fab fa-renren',
            'fab fa-pagelines',
            'fab fa-stack-exchange',
            'far fa-arrow-alt-circle-right',
            'far fa-arrow-alt-circle-left',
            'far fa-caret-square-left',
            'far fa-dot-circle',
            'fa fa-wheelchair',
            'fab fa-vimeo-square',
            'fas fa-lira-sign',
            'far fa-plus-square',
            'fa fa-space-shuttle',
            'fab fa-slack',
            'fa fa-envelope-square',
            'fab fa-wordpress',
            'fab fa-openid',
            'fa fa-university',
            'fa fa-graduation-cap',
            'fab fa-yahoo',
            'fab fa-google',
            'fab fa-reddit',
            'fab fa-reddit-square',
            'fab fa-stumbleupon-circle',
            'fab fa-stumbleupon',
            'fab fa-delicious',
            'fab fa-digg',
            'fab fa-pied-piper-pp',
            'fab fa-pied-piper-alt',
            'fab fa-drupal',
            'fab fa-joomla',
            'fa fa-language',
            'fa fa-fax',
            'fa fa-building',
            'fa fa-child',
            'fa fa-paw',
            'fas fa-utensil-spoon',
            'fa fa-cube',
            'fa fa-cubes',
            'fab fa-behance',
            'fab fa-behance-square',
            'fab fa-steam',
            'fab fa-steam-square',
            'fa fa-recycle',
            'fa fa-car',
            'fa fa-taxi',
            'fa fa-tree',
            'fab fa-spotify',
            'fab fa-deviantart',
            'fab fa-soundcloud',
            'fa fa-database',
            'far fa-file-pdf',
            'far fa-file-word',
            'far fa-file-excel',
            'far fa-file-powerpoint',
            'far fa-file-image',
            'far fa-file-archive',
            'far fa-file-audio',
            'far fa-file-video',
            'far fa-file-code',
            'fab fa-vine',
            'fab fa-codepen',
            'fab fa-jsfiddle',
            'fa fa-life-ring',
            'fas fa-circle-notch',
            'fab fa-rebel',
            'fab fa-empire',
            'fab fa-git-square',
            'fab fa-git',
            'fab fa-hacker-news',
            'fab fa-tencent-weibo',
            'fab fa-qq',
            'fab fa-weixin',
            'fa fa-paper-plane',
            'far fa-paper-plane',
            'fa fa-history',
            'fas fa-icicles',
            'fas fa-heading',
            'fa fa-paragraph',
            'fas fa-sliders-h',
            'fa fa-share-alt',
            'fa fa-share-alt-square',
            'fa fa-bomb',
            'fas fa-futbol',
            'fa fa-tty',
            'fa fa-binoculars',
            'fa fa-plug',
            'fab fa-slideshare',
            'fab fa-twitch',
            'fab fa-yelp',
            'far fa-newspaper',
            'fas fa-wifi',
            'fas fa-calculator',
            'fab fa-paypal',
            'fab fa-google-wallet',
            'fab fa-cc-visa',
            'fab fa-cc-mastercard',
            'fab fa-cc-discover',
            'fab fa-cc-amex',
            'fab fa-cc-paypal',
            'fab fa-cc-stripe',
            'fa fa-bell-slash',
            'far fa-bell-slash',
            'fa fa-trash',
            'fa fa-copyright',
            'fa fa-at',
            'fas fa-eye-dropper',
            'fa fa-paint-brush',
            'fa fa-birthday-cake',
            'fas fa-chart-area',
            'fas fa-chart-pie',
            'fas fa-chart-line',
            'fab fa-lastfm',
            'fab fa-lastfm-square',
            'fa fa-toggle-off',
            'fa fa-toggle-on',
            'fa fa-bicycle',
            'fa fa-bus',
            'fab fa-ioxhost',
            'fab fa-angellist',
            'far fa-closed-captioning',
            'fas fa-shekel-sign',
            'fas fa-drumstick-bite',
            'fab fa-buysellads',
            'fab fa-connectdevelop',
            'fab fa-dashcube',
            'fab fa-forumbee',
            'fab fa-leanpub',
            'fab fa-sellsy',
            'fab fa-shirtsinbulk',
            'fab fa-simplybuilt',
            'fab fa-skyatlas',
            'fa fa-cart-plus',
            'fa fa-cart-arrow-down',
            'far fa-gem',
            'fa fa-ship',
            'fa fa-user-secret',
            'fa fa-motorcycle',
            'fa fa-street-view',
            'fa fa-heartbeat',
            'fa fa-venus',
            'fa fa-mars',
            'fa fa-mercury',
            'fa fa-transgender',
            'fa fa-transgender-alt',
            'fa fa-venus-double',
            'fa fa-mars-double',
            'fa fa-venus-mars',
            'fa fa-mars-stroke',
            'fa fa-mars-stroke-v',
            'fa fa-mars-stroke-h',
            'fa fa-neuter',
            'fa fa-genderless',
            'fab fa-facebook-f',
            'fab fa-pinterest-p',
            'fab fa-whatsapp',
            'fa fa-server',
            'fa fa-user-plus',
            'fa fa-user-times',
            'fa fa-bed',
            'fab fa-viacoin',
            'fa fa-train',
            'fa fa-subway',
            'fab fa-medium',
            'fab fa-y-combinator',
            'fab fa-optin-monster',
            'fab fa-opencart',
            'fab fa-expeditedssl',
            'fa fa-battery-full',
            'fa fa-battery-three-quarters',
            'fa fa-battery-half',
            'fa fa-battery-quarter',
            'fa fa-battery-empty',
            'fa fa-mouse-pointer',
            'fa fa-i-cursor',
            'fa fa-object-group',
            'fa fa-object-ungroup',
            'fa fa-sticky-note',
            'far fa-sticky-note',
            'fab fa-cc-jcb',
            'fab fa-cc-diners-club',
            'fa fa-clone',
            'fa fa-balance-scale',
            'far fa-hourglass',
            'fa fa-hourglass-start',
            'fa fa-hourglass-half',
            'fa fa-hourglass-end',
            'fa fa-hourglass',
            'far fa-hand-rock',
            'far fa-hand-paper',
            'far fa-hand-scissors',
            'far fa-hand-lizard',
            'far fa-hand-spock',
            'far fa-hand-pointer',
            'far fa-hand-peace',
            'fas fa-trademark',
            'fas fa-registered',
            'fab fa-creative-commons',
            'fab fa-gg',
            'fab fa-gg-circle',
            'fab fa-tripadvisor',
            'fab fa-odnoklassniki',
            'fab fa-odnoklassniki-square',
            'fab fa-get-pocket',
            'fab fa-wikipedia-w',
            'fab fa-safari',
            'fab fa-chrome',
            'fab fa-firefox',
            'fab fa-opera',
            'fab fa-internet-explorer',
            'fas fa-tv',
            'fab fa-contao',
            'fab fa-500px',
            'fab fa-amazon',
            'far fa-calendar-plus',
            'far fa-calendar-minus',
            'far fa-calendar-times',
            'far fa-calendar-check',
            'fa fa-industry',
            'fa fa-map-pin',
            'fa fa-map-signs',
            'far fa-map',
            'fa fa-map',
            'fas fa-comment-dots',
            'far fa-comment-dots',
            'fab fa-houzz',
            'fab fa-vimeo',
            'fab fa-black-tie',
            'fab fa-fonticons',
            'fab fa-reddit-alien',
            'fab fa-edge',
            'fas fa-credit-card',
            'fab fa-codiepie',
            'fab fa-modx',
            'fab fa-fort-awesome',
            'fab fa-usb',
            'fab fa-product-hunt',
            'fab fa-mixcloud',
            'fab fa-scribd',
            'fa fa-pause-circle',
            'far fa-pause-circle',
            'fa fa-stop-circle',
            'far fa-stop-circle',
            'fa fa-shopping-bag',
            'fa fa-shopping-basket',
            'fa fa-hashtag',
            'fab fa-bluetooth',
            'fab fa-bluetooth-b',
            'fa fa-percent',
            'fab fa-gitlab',
            'fab fa-wpbeginner',
            'fab fa-wpforms',
            'fab fa-envira',
            'fa fa-universal-access',
            'fab fa-accessible-icon',
            'far fa-question-circle',
            'fa fa-blind',
            'fa fa-audio-description',
            'fas fa-phone-volume',
            'fa fa-braille',
            'fa fa-assistive-listening-systems',
            'fa fa-american-sign-language-interpreting',
            'fa fa-deaf',
            'fab fa-glide',
            'fab fa-glide-g',
            'fas fa-sign-language',
            'fas fa-low-vision',
            'fab fa-viadeo',
            'fab fa-viadeo-square',
            'fab fa-snapchat',
            'fab fa-snapchat-ghost',
            'fab fa-snapchat-square',
            'fab fa-pied-piper',
            'fab fa-first-order',
            'fab fa-yoast',
            'fab fa-themeisle',
            'fab fa-google-plus',
            'fab fa-font-awesome',
            'fas fa-khanda',
            'fab fa-accusoft',
            'fab fa-acquisitions-incorporated',
            'fas fa-ad',
            'fas fa-address-book',
            'far fa-address-book',
            'fas fa-address-card',
            'far fa-address-card',
            'fab fa-adversal',
            'fab fa-affiliatetheme',
            'fas fa-air-freshener',
            'fab fa-airbnb',
            'fab fa-algolia',
            'fab fa-alipay',
            'fas fa-allergies',
            'fab fa-amazon-pay',
            'fab fa-amilia',
            'fas fa-angry',
            'far fa-angry',
            'fab fa-angrycreative',
            'fab fa-angular',
            'fas fa-ankh',
            'fab fa-app-store',
            'fab fa-app-store-ios',
            'fab fa-apper',
            'fab fa-apple',
            'fas fa-apple-alt',
            'fas fa-archway',
            'fab fa-artstation',
            'fab fa-asymmetrik',
            'fas fa-atlas',
            'fab fa-atlassian',
            'fas fa-atom',
            'fab fa-audible',
            'fab fa-autoprefixer',
            'fab fa-avianex',
            'fab fa-aviato',
            'fas fa-award',
            'fab fa-aws',
            'fas fa-baby',
            'fas fa-baby-carriage',
            'fas fa-backspace',
            'fas fa-bacon',
            'fas fa-bahai',
            'fas fa-balance-scale-left',
            'fas fa-balance-scale-right',
            'fas fa-band-aid',
            'fab fa-bandcamp',
            'fas fa-baseball-ball',
            'fas fa-basketball-ball',
            'fas fa-bath',
            'fab fa-battle-net',
            'fas fa-bezier-curve',
            'fas fa-bible',
            'fas fa-biking',
            'fab fa-bimobject',
            'fas fa-biohazard',
            'fab fa-bitcoin',
            'fab fa-bity',
            'fab fa-blackberry',
            'fas fa-blender',
            'fas fa-blender-phone',
            'fas fa-blog',
            'fab fa-blogger',
            'fab fa-blogger-b',
            'fas fa-bone',
            'fas fa-bong',
            'fas fa-book-dead',
            'fas fa-book-medical',
            'fas fa-book-open',
            'fas fa-book-reader',
            'fab fa-bootstrap',
            'fas fa-border-all',
            'fas fa-border-none',
            'fas fa-border-style',
            'fas fa-bowling-ball',
            'fas fa-box',
            'fas fa-box-open',
            'fas fa-box-tissue',
            'fas fa-boxes',
            'fas fa-braille',
            'fas fa-brain',
            'fas fa-bread-slice',
            'fas fa-briefcase-medical',
            'fas fa-broadcast-tower',
            'fas fa-broom',
            'fas fa-brush',
            'fab fa-buffer',
            'fas fa-burn',
            'fab fa-buromobelexperte',
            'fas fa-bus-alt',
            'fas fa-business-time',
            'fab fa-buy-n-large',
            'fas fa-calendar-alt',
            'far fa-calendar-alt',
            'fas fa-calendar-check',
            'fas fa-calendar-day',
            'fas fa-calendar-minus',
            'fas fa-calendar-plus',
            'fas fa-calendar-times',
            'fas fa-calendar-week',
            'fas fa-campground',
            'fab fa-canadian-maple-leaf',
            'fas fa-candy-cane',
            'fas fa-cannabis',
            'fas fa-capsules ',
            'fas fa-car-alt',
            'fas fa-car-battery ',
            'fas fa-car-crash',
            'fas fa-car-side',
            'fas fa-caravan',
            'far fa-caret-square-down',
            'fas fa-caret-square-left',
            'far fa-caret-square-right',
            'far fa-caret-square-up',
            'fas fa-carrot',
            'fas fa-cash-register',
            'fas fa-cat',
            'fab fa-cc-amazon-pay',
            'fab fa-cc-apple-pay',
            'fab fa-centercode',
            'fab fa-centos',
            'fas fa-chair',
            'fas fa-chalkboard',
            'fas fa-chalkboard-teacher',
            'fas fa-charging-station',
            'fas fa-chart-bar',
            'fas fa-check-double',
            'fas fa-cheese',
            'fas fa-chess',
            'fas fa-chess-bishop',
            'fas fa-chess-board',
            'fas fa-chess-king',
            'fas fa-chess-knight',
            'fas fa-chess-pawn',
            'fas fa-chess-queen',
            'fas fa-chess-rook',
            'fab fa-chromecast',
            'fas fa-church',
            'fas fa-city',
            'fas fa-clinic-medical',
            'far fa-clipboard',
            'fas fa-clipboard-check',
            'fas fa-clipboard-list',
            'fas fa-clock',
            'far fa-clone',
            'fas fa-closed-captioning',
            'fas fa-cloud-meatball',
            'fas fa-cloud-moon',
            'fas fa-cloud-moon-rain',
            'fas fa-cloud-rain',
            'fas fa-cloud-showers-heavy',
            'fas fa-cloud-sun',
            'fas fa-cloud-sun-rain',
            'fab fa-cloudflare',
            'fab fa-cloudscale',
            'fab fa-cloudsmith',
            'fab fa-cloudversify',
            'fas fa-cocktail',
            'fas fa-code-branch',
            'fas fa-coins',
            'fas fa-comment-alt',
            'far fa-comment-alt',
            'fas fa-comment-dollar',
            'fas fa-comment-medical',
            'fas fa-comment-slash',
            'fas fa-comments-dollar',
            'fas fa-compact-disc',
            'far fa-compass',
            'fas fa-compress',
            'fas fa-compress-alt',
            'fas fa-compress-arrows-alt',
            'fas fa-concierge-bell',
            'fab fa-confluence',
            'fas fa-cookie',
            'fas fa-cookie-bite',
            'fas fa-copy'
        ];
        $output = [];
        foreach ($font_icons as $font_icon) $output[$font_icon] = $font_icon;

        return apply_filters('afeb/strs/font_icons', $output);
    }
}
