<?php

namespace AFEB;

use AFEB\Controls\CHelper;
use AFEB\PostTypes\Builder;
use AFEB\PostTypes\Popup;

if (!defined('ABSPATH')) {
    exit;
}

/**
 * "Vertex Addons for Elementor" Documents Class
 * 
 * @class Documents
 * @version 1.2.0
 */
class Documents extends Base
{
    /**
     * @var CHelper
     */
    private $CHelper;

    /**
     * @var Widgets
     */
    public $Widgets;

    /**
     * Initialize "Vertex Addons for Elementor" Documents
     * 
     * @since 1.2.0
     */
    public function init()
    {
        $this->CHelper = new CHelper();
        $this->Widgets = new Widgets();
        $this->actions();
    }

    /**
     * Documents Class Actions
     * 
     * @since 1.2.0
     */
    public function actions()
    {
        add_action('elementor/documents/register', [$this, 'register_document_type']);
        add_action('afeb/document/settings/after_render_setting_section', [$this, 'add_request_feature_section']);
        add_action('afeb/document/settings/after_render_setting_section', [$this, 'add_bug_report_section']);
    }

    /**
     * Register document type for the popup creator
     * 
     * @since 1.2.0
     * 
     * @param object $documents_manager
     */
    public function register_document_type($documents_manager)
    {
        $documents_manager->register_document_type(Builder::BUILDER_POST_TYPE, new \AFEB\Documents\Builder());
        $documents_manager->register_document_type(Popup::POPUP_POST_TYPE, new \AFEB\Documents\Popup());
    }

    /**
     * Add feature request section in all documents
     * 
     * @since 1.2.0
     * 
     * @param object $document
     */
    public function add_request_feature_section($document)
    {
        $this->CHelper->add_set_sctn($document, 'ranf', esc_html__('Request a New Feature', 'addons-for-elementor-builder'), function ($obj) {
            $this->Widgets->request_feature_section($this->CHelper, $obj);
        });
    }

    /**
     * Add bug report section in all documents
     * 
     * @since 1.2.0
     * 
     * @param object $document
     */
    public function add_bug_report_section($document)
    {
        $this->CHelper->add_set_sctn($document, 'rab', esc_html__('Report a Bug', 'addons-for-elementor-builder'), function ($obj) {
            $this->Widgets->bug_report_section($this->CHelper, $obj);
        });
    }
}
